/*
 * Decompiled with CFR 0.152.
 */
package mhzd.net.MoreOre.util;

import com.google.common.base.Predicate;
import java.util.Random;
import mhzd.net.MoreOre.init.ModBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGeneration
implements IWorldGenerator {
    private WorldGenerator quartz_ore = new WorldGenMinable(ModBlock.quartz_ore.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateHell(world, random, chunkX, chunkZ);
                break;
            }
            case 0: {
                this.generateWorld(world, random, chunkX, chunkZ);
                break;
            }
        }
    }

    public void generateHell(World world, Random random, int chunkX, int chunkZ) {
        this.runGenerator(this.quartz_ore, world, random, chunkX, chunkZ, 90, 1, 200);
    }

    public void generateWorld(World world, Random rand, int x, int z) {
        this.generateOre(ModBlock.redstone_ore.func_176223_P(), world, rand, x, z, 5, 8, 20, 0, 60, Blocks.field_150348_b);
        this.generateOre(ModBlock.lapis_ore.func_176223_P(), world, rand, x, z, 5, 8, 20, 0, 60, Blocks.field_150348_b);
        this.generateOre(ModBlock.coal_ore.func_176223_P(), world, rand, x, z, 8, 12, 50, 0, 60, Blocks.field_150348_b);
        this.generateOre(ModBlock.iron_ore.func_176223_P(), world, rand, x, z, 3, 8, 40, 0, 60, Blocks.field_150348_b);
        this.generateOre(ModBlock.gold_ore.func_176223_P(), world, rand, x, z, 4, 8, 20, 0, 40, Blocks.field_150348_b);
        this.generateOre(ModBlock.diamond_ore.func_176223_P(), world, rand, x, z, 4, 6, 15, 0, 20, Blocks.field_150348_b);
        this.generateOre(ModBlock.emerald_ore.func_176223_P(), world, rand, x, z, 4, 6, 8, 0, 30, Blocks.field_150348_b);
    }

    public void generateOre(IBlockState ore, World world, Random random, int chunkX, int chunkZ, int minVienSize, int maxVienSize, int chance, int minY, int maxY, Block generateIn) {
        int vienSize = minVienSize + random.nextInt(maxVienSize - minVienSize);
        int heightRange = maxY - minY;
        WorldGenMinable gen = new WorldGenMinable(ore, vienSize);
        for (int i = 0; i < chance; ++i) {
            int xRand = chunkX * 16 + random.nextInt(16);
            int yRand = random.nextInt(heightRange) + minY;
            int zRand = chunkZ * 16 + random.nextInt(16);
            BlockPos pos = new BlockPos(xRand, yRand, zRand);
            gen.func_180709_b(world, random, pos);
        }
    }

    private void runGenerator(WorldGenerator gen, World world, Random rand, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        if (minHeight > maxHeight || minHeight < 0 || maxHeight > 256) {
            throw new IllegalArgumentException("Ore generated out of bounds");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chance; ++i) {
            int x = chunkX * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunkZ * 16 + rand.nextInt(16);
            gen.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

